#! /usr/bin/python
#
# Utility command to fetch from all repositories
#
#  Utilize something like this, ahead of time, to cache https credentials...
#  git config --global credential.helper cache
#  git config --global credential.https://vadev.mantech.com darmbrust

import subprocess







projects = ['ISAAC-developer-docs',
			'ISAAC',
			'ISAAC-term-convert-cpt',
			'ISAAC-term-convert-cvx',
			'ISAAC-term-convert-nucc',
			'ISAAC-term-convert-hl7v3',
			'ISAAC-term-convert-icd10',
			'ISAAC-term-convert-rf2',
			'ISAAC-term-convert-vhat',
			'ISAAC-term-convert-loinc',
			'ISAAC-term-convert-mvx',
			'ISAAC-term-convert-rxnorm',
			'ISAAC-term-convert-sopt',
			'ISAAC-db-builder-solor',
			'ISAAC-db-builder-vhat',
			'ISAAC-db-builder-vets',
			'ISAAC-fx-gui',
			'ISAAC-fx-gui-pa',
			'ISAAC-rest',
			'ISAAC-file-transfer-utils',
			'rails_common',
			'rails_komet',
			'rails_prisme',
			'VUID-rest',
			'apache_extensions',
			'aitc_install']

def git(*args):
	return subprocess.check_call(['git'] + list(args))

#Developers, set this according to your remote name - 'origin' is the git default, but with multiple remotes, the commented out convention below may work better...
remoteOne = 'origin'
#remoteOne = 'origin'
#remoteTwo = 'vadev'

for project in projects:
	print("==================================")
	print("Fetching Latest from " + project)
	git("-C", project, "fetch", remoteOne)
#	git("-C", project, "fetch", remoteTwo)
	git("-C", project, "status")
	print("==================================")
	print("");